/** @file   www_exceptions.h
 * @brief   This header contains the <code>Exception</code> - classes.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_WWWEXCEPTION_H
#define H_WWW_WWWEXCEPTION_H

#include <string>


namespace WeWantWar {

/** @class  Exception
 * @brief   The baseclass of all the exceptions.
 * @author  Tomi Lamminsaari
 *
 * Possible error conditions in WeWantWar - code are reported to the
 * main()-function by instances of this class.
 */
class Exception
{
public:
  ///
  /// Members
  /// =======
  
  /** String for the message */
  std::string m_message;
  /** An id-code for the exception. */
  int   m_id;
  
  
  
  ///
  /// Constructors, destructor and operators
  /// ======================================
  
  /** Constructs new exception and sets the id.
   * @param     id                The id-code
   */
  Exception( int id ) :
    m_message( "" ),
    m_id ( id )
  {
  }
  
  /** Constructs new exception.
   * @param     mess              The message this exception delivers.
   */
  Exception( const std::string& mess ) :
    m_message( mess ),
    m_id( 0 )
  {
  }
  
   
  /** Destructor.
   */
  virtual ~Exception()
  {
  }
  
  
  
  /** Returns the message.
   * @return    A reference to the message string.
   */
  virtual const std::string& message() const
  {
    return m_message;
  }
  
  /** Returns the id-code of this exception
   * @return    An id-code.
   */
  virtual int id() const
  {
    return m_id;
  }
  
};


};  // end of namespace

#endif // WWWEXCEPTION_H

/**
 * Version history
 * ===============
 * $Log: www_exceptions.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:22+02  lamminsa
 * Initial revision
 *
 */
 
